const MessagesContainerSelector = '#pro-messages';

const LoadingRowSelector = '#pro-loading-row';
const MessageRowSelector = '.pro-message-row';
const FooterRowSelector = '#pro-footer-row';

const MessageRowTemplateSelector = '#pro-message-row-template';
const MessageErrorAlertTemplate = '#pro-message-error-alert-template';
const TextFieldTemplateSelector = '#pro-text-field-template';
const TimerFieldTemplateSelector = '#pro-timer-field-template';

const MessageRowContentSelector = '.pro-message-row-content';

const MessageFormSelector = '.pro-message-form';
const NameHeaderSelector = '.pro-name-header';
const SendButtonSelector = '.pro-send-button';
const SendingMessageSelector = '.pro-sending-message';
const SuccessImageSelector = '.pro-success-image';

const FieldSelector = '.pro-field';

const FieldInputSelector = '.pro-field-input';
const FieldLabelSelector = '.pro-field-label';

const RefreshDelay = 5000;
const AnimationDuration = 200;
const HoldResultDelay = 2000;

let isInitialLoad = true;
let lastMessages = [];

$(function() {
  LoadMessages();
});

function LoadMessages() {
  Get('/v1/messages')
    .done(function(result) {
      DisplayMessages(result);
    })
    .always(function() {
      setTimeout(LoadMessages, RefreshDelay);
    });
}

function DisplayMessages(messages) {
  if (isInitialLoad) {
    isInitialLoad = false;

    $(LoadingRowSelector).hide();
    $(FooterRowSelector).show();
  }
  else if (equal(messages, lastMessages))
    return;

  $(MessagesContainerSelector).find(MessageRowSelector).remove();

  lastMessages = messages;

  for (var i = 0; i < messages.length; ++i) {
    let message = messages[i];
    if (message.visible_on_network) {
      $(FooterRowSelector).before(CreateMessageRow(message.id.uuid, message.id.name, message.tokens));
    }
  }
}

function CreateMessageRow(id, name, fields) {
  let messageRow = $($(MessageRowTemplateSelector).html());

  messageRow.find(MessageFormSelector).prop('id', id);
  messageRow.find(NameHeaderSelector).text(name);

  BindClick(messageRow.find(SendButtonSelector), SendMessage);

  let messageForm = messageRow.find(MessageFormSelector);

  for (let i = 0; i < fields.length; ++i) {
    let field = fields[i];

    if (field.hasOwnProperty('text')) {
        messageForm.append(CreateTextField(id + field.name, field.name));
    }
    else if (field.hasOwnProperty('timer')) {
      let duration = 0;
      if (field.timer.hasOwnProperty('countdown')) {
        duration = field.timer.countdown.duration;
      } else if (field.timer.hasOwnProperty('count_down_to_time') !== null) {
        duration = field.timer.count_down_to_time.time_of_day;
      }

      let hours = Math.floor(duration / 3600);
      let minutes = Math.floor((duration / 60) % 60).toString().padStart(2, '0');
      let seconds = Math.floor(duration % 60).toString().padStart(2, '0');

      messageForm.append(CreateTimerField(id + field.name, field.name,`${hours}:${minutes}:${seconds}`));
      break;
    }
  }

  return messageRow;
};

function CreateTextField(id, name) {
  let textField = $($(TextFieldTemplateSelector).html());
  let input = textField.find(FieldInputSelector);
  let label = textField.find(FieldLabelSelector);

  SetID(input, id);

  label.prop('for', id);
  label.text(name);

  return textField;
}

function CreateTimerField(id, name, value) {
  let textField = $($(TimerFieldTemplateSelector).html());
  let input = textField.find(FieldInputSelector);
  let label = textField.find(FieldLabelSelector);

  SetID(input, id);
  input.val(value);

  label.prop('for', id);
  label.text(name);

  return textField;
}

function SendMessage(sender) {
  let sendButton = $(sender);
  let messageRow = sendButton.closest(MessageRowSelector);
  let messageForm = messageRow.find(MessageFormSelector);
  let sendingMessage = messageRow.find(SendingMessageSelector);
  let successImage = messageRow.find(SuccessImageSelector);

  let postData = GetFields(messageForm);

  let wasSuccess;
  let isButtonGone = false;
  let isResultDisplayed = false;

  Disable(sendButton);

  sendButton.fadeOut(AnimationDuration, function() {
    isButtonGone = true;

    sendingMessage.show();
    DisplayResult();
   });

  function DisplayResult() {
    if (isResultDisplayed)
      return;

    if (wasSuccess !== undefined && isButtonGone) {
      isResultDisplayed = true;

      sendingMessage.hide();
      Enable(sendButton);

      if (wasSuccess) {
        successImage.fadeIn(AnimationDuration, function() {
          setTimeout(function() {
            successImage.fadeOut(AnimationDuration, function() {
              sendButton.fadeIn(AnimationDuration);
            });
          }, HoldResultDelay);
        });
      }
      else {
        messageRow.find(MessageRowContentSelector).prepend($($(MessageErrorAlertTemplate).html()));
        sendButton.fadeIn(AnimationDuration);
      }
    }
  }

  Post(`/v1/message/${GetID(messageForm)}/trigger?requires_confirmation=true`, postData, false)
    .done(function(result) {
      wasSuccess = true;
    })
    .fail(function(err) {
      wasSuccess = false;
    })
    .always(function() {
      DisplayResult();
    });
}

function GetFields(messageForm) {
  let fields = [];

  messageForm.children(FieldSelector).each(function() {
    let input = $(this).find(FieldInputSelector);
    let label = $(this).find(FieldLabelSelector);

    fields.push({
      name: label.text(),
      text: { text: input.val() },
    });
  });

  return fields;
}
