#version 330

#include "transitionHelperGL.h"
#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform sampler2DRect maskTex;

uniform float transitionProgress=1.0;
uniform float transitionProgressLinear=1.0;
uniform float transitionAlpha=1.0;
uniform int transitionState;
uniform float baseAlpha=1.0;
in vec2 fsMaskTexture;

in vec2 fsTexture;
in vec2 fsTexture2;
in vec2 fsDirection;
in vec2 fsNormPos;
in float fsMix;

out vec4 outColor;

uniform ivec2 squares=ivec2(10,10);
uniform float smoothness=1.0;

const vec2 center = vec2(0.5, 0.5);

void main()
{
    vec2 p = fsNormPos;
    vec2 dir = fsDirection;
    float diagonalScale = abs(dir.x) + abs(dir.y);
    if (diagonalScale > 0)
        dir /= diagonalScale;
    float offset = smoothness;
    float prog = dot(dir, p) - dot(dir, center) + 0.5 - transitionProgressLinear * (1.0 + offset);
    float pr = smoothstep(-offset, 0.0, prog) * 0.5;
    vec2 squarep = fract(p * vec2(squares));
    vec2 squaremin = vec2(pr);
    vec2 squaremax = vec2(1.0 - pr);
    float alpha = all(lessThanEqual(squaremin, squarep)) && all(lessThanEqual(squarep, squaremax)) ? 1.0 : 0.0;
    alpha = mix(alpha, 1 - alpha, fsMix);
    alpha *= baseAlpha;

#ifdef USE_MASK
    alpha *= texture(maskTex, fsMaskTexture).a;
#endif

    outColor = getColor(inputTex, fsTexture);
    multiplyOpacity(outColor, alpha);
}
