#version 330

#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform float transitionProgress=1.0;
uniform float transitionProgressLinear=1.0;
uniform float transitionAlpha=1.0;
uniform int transitionState;
uniform float baseAlpha=1.0;
uniform sampler2DRect maskTex;
in vec2 fsMaskTexture;

in vec2 fsTexture;
in vec2 fsTexture2;
in vec2 fsTextureSize;
in float fsMix;

out vec4 outColor;

uniform float blocksize=1.;

//float rand(vec2 co)
//{
//    return fract(sin(dot(co, vec2(12.9898, 78.233))) * 43758.5453);
//}

highp float rand(vec2 co)
{
    highp float a = 12.9898;
    highp float b = 78.233;
    highp float c = 43758.5453;
    highp float dt= dot(co.xy ,vec2(a,b));
    highp float sn= mod(dt,3.14);
    return fract(sin(sn) * c);
}


void main()
{
    vec2 p=fsTexture/fsTextureSize;
    float mixVal=1.;
    //    if(transitionState==0)
    mixVal=step(rand(floor(gl_FragCoord.xy/blocksize)), fsMix);
    vec4 texelA=texture(inputTex,fsTexture);
    vec4 texelB=texture(inputTex1,fsTexture2);
    outColor=mix(texelB,texelA,mixVal);
#ifdef USE_MASK
    multiplyOpacity(outColor, texture(maskTex, fsMaskTexture).a);
#endif
}
