#version 330


layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;
layout (location=2) in vec2 vsTextureMask;
layout (location=3) in vec2 vsTexture2;

uniform sampler2DRect maskTex;
out vec2 fsMaskTexture;



uniform mat4 worldViewProj;
uniform int transitionState;
uniform float transitionProgressLinear=1.0;
uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;

out vec2 fsTexture;
out vec2 fsTextureSize;
out float fsMix;
out float fsABSelect;

void main()
{
    gl_Position=vec4(vsPosition,1.0)*worldViewProj;

    vec2 fsVertex=vsPosition.xy;

    ivec2 texSize=textureSize(inputTex);
    fsTextureSize=vec2(texSize);
    fsTexture = vsTexture*vec2(texSize);
    fsMaskTexture=vsTextureMask*vec2(textureSize(maskTex));


    fsMix=transitionProgressLinear;

    fsABSelect=1.0;
    if(transitionState==2)
        fsABSelect=0.0;
}
