#version 330

#include "alpha.h"

uniform sampler2DRect inputTex;
uniform float uTransitionProgress=1.0;
uniform float uBlackLevel=0;
uniform float uBlueLevel=0;
uniform float uGreenLevel=0;
uniform float uRedLevel=0;
uniform float uGamma=0;
uniform float uAlphaLevel = 0;

in vec3 fsTexture;
out vec4 outColor;

void main()
{
    outColor = texture(inputTex, fsTexture.xy/fsTexture.z);

#ifdef PRE_MULT
    divideAlpha(outColor);
#endif

    outColor.rgb=pow(outColor.rgb,vec3(1.0+uGamma));
    outColor+=vec4(uRedLevel,uGreenLevel,uBlueLevel,0.0);
    float range=1.0-uBlackLevel;
    outColor.rgb*=range;
    outColor.rgb+=uBlackLevel;
    outColor.a += uAlphaLevel * (1.0 - outColor.a);

#ifdef PRE_MULT
    multiplyAlpha(outColor);
#endif
}
