#version 330

uniform sampler2DRect inputTex;
uniform sampler2DRect maskTex;
uniform float speed;
uniform float uLocalTime;


layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;
layout (location=2) in vec2 vsTextureMask;

out vec2 fsTexture;
out vec2 fsMaskTexture;
out vec2 fsPosition;
out vec2 fsTextureSize;
out float fsTime;

void main()
{
    gl_Position=vec4(vsPosition.x,vsPosition.y,vsPosition.z,1.0);
    fsTexture = vsTexture;
    fsPosition=vsPosition.xy;

    ivec2 texSize = textureSize(inputTex);
    fsTexture = vsTexture;
    fsTextureSize=vec2(texSize);
    fsMaskTexture = vsTextureMask;

    fsTime=(speed+0.01)*uLocalTime*10.0;
}
