// Convert (and horizontal downsample) RGB to YUV2 using HD gamma corrected values (from Decklink SDK)
#version 330

uniform sampler2DRect inputTex;

const vec4 std709X = vec4(  0.183,   0.614,  0.062, 0.0  );
const vec4 std709Y = vec4( -0.101,  -0.338,  0.439, 0.0  );
const vec4 std709Z = vec4(  0.439,  -0.399, -0.040, 0.0  );

in vec2 fsTex0;

layout(location = 0) out vec4 yValue;
layout(location = 1) out vec4 uValue;
layout(location = 2) out vec4 vValue;
layout(location = 3) out vec4 aValue;


vec2 ScaleAndSplit(float value)
{
    vec2 ret;

    int tmp=int(value*1023.0);
    ret.x=float(tmp&0xff)/255.0;
    ret.y=float(tmp>>8)/255.0;
    return ret;
}


void main()
{
    vec4 texColor0;
    vec4 texColor1;
    vec4 yuv0;
    vec4 yuv1;
    vec2 texLoc=fsTex0;

    texColor0 = texture(inputTex, texLoc);
    texLoc.x+=1.0;
    texColor1 = texture(inputTex, texLoc);


    yuv0 = vec4(dot(std709X, texColor0)+0.0625,
                dot(std709Y, texColor0)+0.5,
                dot(std709Z, texColor0)+0.5,
                1.0 );
    yuv1 = vec4(dot(std709X, texColor1)+0.0625,
                dot(std709Y, texColor1)+0.5,
                dot(std709Z, texColor1)+0.5,
                1.0 );

    vec2 y0=ScaleAndSplit(yuv0.r);
    vec2 y1=ScaleAndSplit(yuv1.r);

    yValue=vec4(y0.x,y0.y,y1.x,y1.y);

    vec2 u0=ScaleAndSplit(yuv0.g);
    vec2 u1=ScaleAndSplit(yuv1.g);

    uValue=vec4(u0.x,u0.y,u1.x,u1.y);

    vec2 v0=ScaleAndSplit(yuv0.b);
    vec2 v1=ScaleAndSplit(yuv1.b);

    vValue=vec4(v0.x,v0.y,v1.x,v1.y);

    vec2 a0=ScaleAndSplit(texColor0.a);
    vec2 a1=ScaleAndSplit(texColor1.a);

    aValue=vec4(a0.x,a0.y,a1.x,a1.y);
}


