//

// Fragment shader for swapping one color with another
//
// Author: You Know Who
//


#version 330

#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect maskTex;
uniform float uTransitionProgress=1.0;
uniform float uBlendValue=1.0;

uniform vec4 srcColor;
uniform vec4 dstColor;
uniform float tolerance;


in vec2 fsTexture;
in vec2 fsMaskTexture;

out vec4 outColor;


void main(void)
{
    vec4 texel = texture(inputTex, fsTexture);
#ifdef PRE_MULT
    divideAlpha(texel);
#endif
    outColor=texel;
    vec3 diff=abs(texel.rgb-srcColor.rgb);
    if(diff.r<tolerance)
    {
        if(diff.g<tolerance)
        {
            if(diff.b<tolerance)
            {
                outColor.rgb=dstColor.rgb;
            }
        }
    }
    
    float blendValue=uBlendValue;
#ifdef USE_MASK
    blendValue*=texture(maskTex,fsMaskTexture).a;
#endif
    outColor.rgb=mix(texel.rgb,outColor.rgb,blendValue);
#ifdef PRE_MULT
    multiplyAlpha(outColor);
#endif
}

