#version 120

// Fragment shader for Chromatic type effects
//
// Author: Jeff Brown
//

uniform sampler2DRect texUnit;
uniform  vec4 modulateColor;
uniform int mode;
uniform vec2 dxRed;
uniform vec2 dxBlue;
uniform vec2 dxGreen;

uniform vec4 textureRect;

varying vec2 gUV;
uniform float randomValue;


vec3 mod289(vec3 x) { return (x - floor(x * (1.0 / 289.0)) * 289.0); }
vec2 mod289(vec2 x)  { return x - floor(x * (1.0 / 289.0)) * 289.0; }
vec3 permute(vec3 x) { return mod289(((x*34.0)+1.0)*x); }

float Snoise (vec2 v)
{
    const vec4 C = vec4(0.211324865405187, // (3.0-sqrt(3.0))/6.0
                        0.366025403784439, // 0.5*(sqrt(3.0)-1.0)
                        -0.577350269189626, // -1.0 + 2.0 * C.x
                        0.024390243902439); // 1.0 / 41.0

    // First corner
    vec2 i  = floor(v + dot(v, C.yy) );
    vec2 x0 = v -   i + dot(i, C.xx);

    // Other corners
    vec2 i1;
    i1 = (x0.x > x0.y) ? vec2(1.0, 0.0) : vec2(0.0, 1.0);
    vec4 x12 = x0.xyxy + C.xxzz;
    x12.xy -= i1;

    // Permutations
    i = mod289(i); // Avoid truncation effects in permutation
    vec3 p = permute( permute( i.y + vec3(0.0, i1.y, 1.0 ))
                     + i.x + vec3(0.0, i1.x, 1.0 ));

    vec3 m = max(0.5 - vec3(dot(x0,x0), dot(x12.xy,x12.xy), dot(x12.zw,x12.zw)), 0.0);
    m = m*m ;
    m = m*m ;

    // Gradients: 41 points uniformly over a line, mapped onto a diamond.
    // The ring size 17*17 = 289 is close to a multiple of 41 (41*7 = 287)

    vec3 x = 2.0 * fract(p * C.www) - 1.0;
    vec3 h = abs(x) - 0.5;
    vec3 ox = floor(x + 0.5);
    vec3 a0 = x - ox;

    // Normalise gradients implicitly by scaling m
    // Approximation of: m *= inversesqrt( a0*a0 + h*h );
    m *= 1.79284291400159 - 0.85373472095314 * ( a0*a0 + h*h );

    // Compute final noise value at P
    vec3 g;
    g.x  = a0.x  * x0.x  + h.x  * x0.y;
    g.yz = a0.yz * x12.xz + h.yz * x12.yw;
    return 2000.0 * dot(m, g);
}


void main(void)
{
    if ( gUV.x< textureRect.x || gUV.x> textureRect.x+textureRect.z || gUV.y < textureRect.y || gUV.y > textureRect.y+textureRect.w )
        gl_FragColor = vec4(0.0,0.0,0.0,0.0);
    else
    {
        float textureWidth = textureRect.z;
        float textureHeight = textureRect.w;

        vec4 texel = texture2DRect(texUnit, gUV);
        vec2 tmp=gUV-vec2(textureWidth*.5,textureHeight*.5);

        tmp/=vec2(textureWidth*.5,textureHeight*.5);
        //    tmp=vec2(1.,1.)-tmp;
        float scale=1.0-sqrt(tmp.x*tmp.x+tmp.y*tmp.y);

        vec2 redLoc=gUV+dxRed*scale;
        vec2 greenLoc=gUV+dxGreen*scale;
        vec2 blueLoc=gUV+dxBlue*scale;

        //    float noise=Snoise(vec2(randomValue * 512.0,randomValue * 512.0));
        //    redLoc.x+=noise;
        //    vec2 greenLoc=gUV;
        //    greenLoc.x-=noise;
        //    vec2 blueLoc=gUV;
        //    blueLoc.x-=noise*.5;

        vec4 red=texture2DRect(texUnit,redLoc)*vec4(0.0,0.0,1.0,1.0);
        vec4 green=texture2DRect(texUnit,greenLoc)*vec4(0.0,1.0,0.0,1.0);
        vec4 blue=texture2DRect(texUnit,blueLoc)*vec4(1.0,0.0,0.0,1.0);

        //    gl_FragColor = mix(texel,red+blue+green,.5f);
        gl_FragColor = red+blue+green;
    }
}
