#version 330

uniform sampler2DRect inputTex;
uniform sampler2DRect maskTex;

layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;

uniform float uPass=0.0;
uniform float blurAmount;

out vec2 fsTexCoords[4];
out vec2 fsTexture;
out vec2 fsMaskTexture;

void main()
{
    gl_Position=vec4(vsPosition.x,vsPosition.y,vsPosition.z,1.0);

    ivec2 iTexSize=textureSize(inputTex);
    vec2 texSize=vec2(iTexSize);
    fsMaskTexture=vsTexture/texSize;

    iTexSize=textureSize(maskTex);
    fsMaskTexture*=vec2(iTexSize);

    float scale=(uPass+1.0)*(blurAmount*.8+.2);
    vec2 pixelOffset=vec2(1.0,1.0);
    fsTexture=vsTexture;
    if(uPass==0.0)
    {
        fsTexture*=vec2(4.0,4.0);
    }

    fsTexCoords[0]=fsTexture+pixelOffset*vec2(-.5,.5)*scale;
    fsTexCoords[1]=fsTexture+pixelOffset*vec2(.5,-.5)*scale;
    fsTexCoords[2]=fsTexture+pixelOffset*vec2(.5,.5)*scale;
    fsTexCoords[3]=fsTexture+pixelOffset*vec2(-.5,-.5)*scale;
}
