#include <metal_stdlib>
#pragma clang diagnostic ignored "-Wparentheses-equality"
using namespace metal;
struct vertexOutput {
  float2 fsTexture;
  float fsCosHue;
  float fsSinHue;
};
struct fragmentOutput {
  half4 outColor [[color(0)]];
};
struct AdjustColorUniform {
  float contrast;
  float brightness;
  float saturation;
  float uBlendValue = 1.0;
};
fragment fragmentOutput AdjustColorFrag(vertexOutput input [[stage_in]],constant AdjustColorUniform& uniforms[[ buffer(1) ]]
  ,   texture2d<float> inputTex [[texture(0)]])
{
  fragmentOutput out;
  constexpr sampler effectSampler (coord::pixel,address::clamp_to_zero, filter::linear);

  half4 yuvOut_1 = 0;
  half4 tmpvar_2 = 0;
  tmpvar_2 = half4(inputTex.sample(effectSampler, (float2)(input.fsTexture)));
  half tmpvar_3 = 0;
  tmpvar_3 = dot ((half4)float4(-0.169, -0.331, 0.5, 0.0), tmpvar_2);
  half tmpvar_4 = 0;
  tmpvar_4 = dot ((half4)float4(0.5, -0.419, -0.081, 0.0), tmpvar_2);
  yuvOut_1.y = ((half)((float)(((half)((float)(dot ((half4)float4(0.299, 0.587, 0.114, 0.0), tmpvar_2)) * uniforms.contrast))) + uniforms.brightness));
  float tmpvar_5 = 0;
  tmpvar_5 = (uniforms.contrast * uniforms.saturation);
  yuvOut_1.x = ((half)((float)((((half)((float)(tmpvar_4) * input.fsCosHue)) + ((half)((float)(tmpvar_3) * input.fsSinHue)))) * tmpvar_5));
  yuvOut_1.z = ((half)((float)((((half)((float)(tmpvar_3) * input.fsCosHue)) - ((half)((float)(tmpvar_4) * input.fsSinHue)))) * tmpvar_5));
  yuvOut_1.w = half(1.0);
  half4 tmpvar_6 = 0;
  tmpvar_6.x = dot ((half4)float4(1.370706, 1.0, 0.0, 0.0), yuvOut_1);
  tmpvar_6.y = dot ((half4)float4(-0.6981964, 1.0, -0.3364546, 0.0), yuvOut_1);
  tmpvar_6.z = dot ((half4)float4(0.0, 1.0, 1.732447, 0.0), yuvOut_1);
  tmpvar_6.w = tmpvar_2.w;
  out.outColor.w = tmpvar_6.w;
  out.outColor.xyz = ((half3)mix ((float3)tmpvar_2.xyz, (float3)tmpvar_6.xyz, uniforms.uBlendValue));
  return out;
}


// stats: 19 alu 1 tex 0 flow
// inputs: 3
//  #0: fsTexture (high float) 2x1 [-1]
//  #1: fsCosHue (high float) 1x1 [-1]
//  #2: fsSinHue (high float) 1x1 [-1]
// uniforms: 4 (total size: 16)
//  #0: contrast (high float) 1x1 [-1] loc 0
//  #1: brightness (high float) 1x1 [-1] loc 4
//  #2: saturation (high float) 1x1 [-1] loc 8
//  #3: uBlendValue (high float) 1x1 [-1] loc 12
// textures: 1
//  #0: inputTex (high other) 0x0 [-1] loc 0
