#version 330


layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;
layout (location=2) in vec2 vsTextureMask;

uniform sampler2DRect maskTex;
uniform vec2 windowSize;
out vec2 fsFragScale;


uniform mat4 worldViewProj;
uniform int transitionState;
uniform float transitionProgress=1.0;
uniform int direction=0;
uniform sampler2DRect inputTex;

const vec4 deltaTransTable[9] = vec4[]  (
                                         vec4(-2.,2.,0.,.0),
                                         vec4( 0.,2.,0.,.0),
                                         vec4( 2.,2.,0.,.0),
                                         vec4(-2.,0.,0.0,.0),
                                         vec4( 0.,0.,0.0,.0),
                                         vec4( 2.,0.,0.0,.0),
                                         vec4(-2.,-2.,0.,.0),
                                         vec4( 0.,-2.,0.,.0),
                                         vec4( 2.,-2.,0.,.0)
                                         );

out vec2 fsTexture;
out float fsMix;

void main()
{
    vec4 deltaTrans=deltaTransTable[direction];
    vec4 transOffset=vec4(0.,0.,0.0,.0);

    mat4 translation=mat4(
                          1.0, 0.0, 0.0, 0.00,
                          0.0, 1.0, 0.0, 0.00,
                          0.0, 0.0, 1.0, 0.00,
                          0.0, 0.0, 0.0, 1.00);


    vec4 tmpPos=vec4(vsPosition.x,vsPosition.y,vsPosition.z,1.0)*worldViewProj;
    if(transitionState==2)
    {
        transOffset-=deltaTrans*transitionProgress;

        translation[0][3]+=transOffset.x;
        translation[1][3]+=transOffset.y;
        translation[2][3]+=transOffset.z;
        fsMix=1.;
    }
    else
    {
        fsMix=transitionProgress;
    }
    gl_Position = tmpPos*translation;

    ivec2 texSize=textureSize(inputTex);
    fsTexture = vsTexture*vec2(texSize);
    fsFragScale=vec2(textureSize(maskTex))/windowSize;
}
