#version 330

#include "transitionHelperGL.h"
#include "kaleidoscopeHelper.h"
#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform sampler2DRect maskTex;
uniform float transitionProgress=1.0;
uniform float transitionProgressLinear=1.0;
uniform float transitionAlpha=1.0;
uniform float baseAlpha=1.0;
uniform vec4 burnColor;

in vec2 fsTexture;
in vec2 fsTextureSize;
in vec2 fsMaskTexture;
in vec2 fsTextureNormalized;
in float fsMix;
in float fsABSelect;

out vec4 outColor;

uniform float speed=1.;
uniform float angle=2.;
uniform float power=2.;

void main()
{
    vec2 p = fsTextureNormalized;
    kaleidoscopeTransform(p, transitionProgressLinear, power, speed);

    vec4 colorA = getColor(inputTex, fsTexture);
#ifdef OPACITY_MASK
    vec4 texColor = colorA;
#endif
    vec4 colorA2 = getColor(inputTex, p * fsTextureSize);

#ifndef PRE_MULT
    multiplyAlpha(colorA);
    multiplyAlpha(colorA2);
#endif

    vec4 colorB = colorA;
    multiplyOpacityPremultiplied(colorB, transitionAlpha);
    colorA = mix(colorA, colorA2, 1.0 - 2.0*abs(transitionProgressLinear - 0.5));
    outColor = mix(colorB, colorA, fsABSelect);

#ifdef OPACITY_MASK
    float maxOpacity = texColor.a;
    outColor = min(outColor, vec4(maxOpacity));
#endif

    float alpha = fsMix * baseAlpha;

#ifdef USE_MASK
    alpha *= texture(maskTex, fsMaskTexture).a;
#endif

    multiplyOpacityPremultiplied(outColor, alpha);

#ifndef PRE_MULT
    divideAlpha(outColor);
#endif
}
