#include "metalShaderTypes.h"
#include "alpha.h"
#include "fadeHelper.h"

typedef struct
{
    float4 burnColor;
} fxVars;

vertex vertexOut vertexFunc(uint vertexID [[ vertex_id ]],
                            const device txShaderVers* in[[ buffer(0) ]],
                            constant txShaderUniforms& uniforms[[ buffer(3) ]],
                            constant fxVars& vars[[ buffer(2)]])
{
    vertexOut out;

    out.position=in[vertexID].pos*uniforms.worldViewProj;

    out.tex1=in[vertexID].tex1;
    out.tex2=in[vertexID].tex2;
    out.texMask=in[vertexID].texMask;
    return out;
}

fragment float4 fragmentFunc(vertexOut input [[stage_in]]
                             ,texture2d<half> inputTex0 [[ texture(0) ]]
                             ,texture2d<half> inputTex1 [[ texture(1) ]]
                             ,texture2d<half> inputTexMask [[ texture(2) ]]
                             ,constant txShaderUniforms& u[[ buffer(2) ]]
                             ,constant subFXVars& subVars[[buffer(3)]]
                             ,constant fxVars& vars[[ buffer(1)]])
{
    vec4 texColor = getColor(inputTex0, input.tex1);
    vec4 outColor;
    fadeDark(outColor, texColor, u.transitionProgress, u.mix);
    float alpha = u.baseAlpha;
#ifdef USE_MASK
    alpha *= float(inputTexMask.sample(linearSampler, input.texMask).a);
#endif
    multiplyOpacity(outColor, alpha);
    return outColor;
}
