// Convert (and horizontal downsample) RGB to YUV2 using std 601 (this seems to be what Blackmagic card likes)
#version 330

uniform sampler2DRect inputTex;

const vec4 std601X = vec4(  0.299 ,  0.587,  0.114, 0.0  );
const vec4 std601Y = vec4( -0.169 , -0.331,  0.500, 0.0  );
const vec4 std601Z = vec4(  0.500 , -0.419, -0.081, 0.0  );

in vec2 fsUL1;
in vec2 fsUR1;
in vec2 fsLL1;
in vec2 fsLR1;
in vec2 fsUL2;
in vec2 fsUR2;
in vec2 fsLL2;
in vec2 fsLR2;

in vec2 fsTexture;
out vec4 outColor;

void main()
{
    vec4 texColor0;
    vec4 texColor1;
    vec4 yuv0;
    vec4 yuv1;

    texColor0 = texture(inputTex, fsUL1);
    texColor0+= texture(inputTex, fsUR1);
    texColor0+= texture(inputTex, fsLL1);
    texColor0+= texture(inputTex, fsLR1);
    texColor0*=0.25;

    texColor1 = texture(inputTex, fsUL2);
    texColor1+= texture(inputTex, fsUR2);
    texColor1+= texture(inputTex, fsLL2);
    texColor1+= texture(inputTex, fsLR2);
    texColor1*=0.25;

    yuv0 = vec4(dot(std601X, texColor0)+0.0425,
                dot(std601Y, texColor0)+0.5,
                dot(std601Z, texColor0)+0.5,
                1.0 );
    
    yuv1 = vec4(dot(std601X, texColor1)+0.0425,
                dot(std601Y, texColor1)+0.5,
                dot(std601Z, texColor1)+0.5,
                1.0 );


    outColor.a = yuv1.r;
    outColor.r = (yuv0.b+yuv1.b)*.5;
    outColor.b = (yuv0.g+yuv1.g)*.5;
    outColor.g = yuv0.r;
}


