#version 330

uniform sampler2DRect inputTex;
uniform sampler2DRect maskTex;
uniform float pixelSize;
uniform float uBlendValue=1.0;

layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;


out vec2 fsTexture;
out vec2 fsMaskTexture;
out vec2 fsNormalizedUV;
out vec2 fsTextureSize;
out vec2 fsTextureStep;

void main()
{
    gl_Position=vec4(vsPosition.x,vsPosition.y,vsPosition.z,1.0);
    fsTexture = vsTexture;
    ivec2 texSize=textureSize(inputTex);
    fsTextureSize=vec2(texSize);
    fsNormalizedUV=vsTexture/fsTextureSize;
    fsMaskTexture=fsNormalizedUV;
    texSize=textureSize(maskTex);
    fsMaskTexture*=vec2(texSize);

    vec2 step=fsTextureSize*.05;
    step*=pixelSize*max(0.01,uBlendValue);
    step.y=step.x;
    fsTextureStep=step;
}
