#version 330

uniform sampler2DRect inputTex;
uniform sampler2DRect maskTex;

layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;

uniform float uPass=0.0;
uniform float blurAmount;

out vec2 fsTexCoords[15];
out vec2 fsTexture;
out vec2 fsMaskTexture;

void main()
{
    float fsScale;
    gl_Position=vec4(vsPosition.x,vsPosition.y,vsPosition.z,1.0);

    fsScale=blurAmount*3.0;
    if(fsScale==0.0)
        fsScale=0.1;

    ivec2 iTexSize=textureSize(inputTex);
    vec2 texSize=vec2(iTexSize);
    fsMaskTexture=vsTexture/texSize;

    iTexSize=textureSize(maskTex);
    fsMaskTexture*=vec2(iTexSize);

    vec2 direction;
    float pass=uPass;
    if(pass>1)
        pass-=2;
    if(pass==0)
    {
        direction=vec2(fsScale,0.0);
    }
    else
    {
        direction=vec2(0.0,fsScale);
    }
    fsTexture=vsTexture;


    
    vec2 dsTexture=vsTexture;

    fsTexCoords[ 0] = dsTexture + vec2(-7.0,-7.0)*direction;
    fsTexCoords[ 1] = dsTexture + vec2(-6.0,-6.0)*direction;
    fsTexCoords[ 2] = dsTexture + vec2(-5.0,-5.0)*direction;
    fsTexCoords[ 3] = dsTexture + vec2(-4.0,-4.0)*direction;
    fsTexCoords[ 4] = dsTexture + vec2(-3.0,-3.0)*direction;
    fsTexCoords[ 5] = dsTexture + vec2(-2.0,-2.0)*direction;
    fsTexCoords[ 6] = dsTexture + vec2(-1.0,-1.0)*direction;
    fsTexCoords[ 7] = dsTexture + vec2( 1.0, 1.0)*direction;
    fsTexCoords[ 8] = dsTexture + vec2( 2.0, 2.0)*direction;
    fsTexCoords[ 9] = dsTexture + vec2( 3.0, 3.0)*direction;
    fsTexCoords[10] = dsTexture + vec2( 4.0, 4.0)*direction;
    fsTexCoords[11] = dsTexture + vec2( 5.0, 5.0)*direction;
    fsTexCoords[12] = dsTexture + vec2( 6.0, 6.0)*direction;
    fsTexCoords[13] = dsTexture + vec2( 7.0, 7.0)*direction;
    fsTexCoords[14] = dsTexture;
    fsTexCoords[0]=clamp(fsTexCoords[0],vec2(0,0),texSize);
    fsTexCoords[1]=clamp(fsTexCoords[1],vec2(0,0),texSize);
    fsTexCoords[2]=clamp(fsTexCoords[2],vec2(0,0),texSize);
    fsTexCoords[3]=clamp(fsTexCoords[3],vec2(0,0),texSize);
    fsTexCoords[4]=clamp(fsTexCoords[4],vec2(0,0),texSize);
    fsTexCoords[5]=clamp(fsTexCoords[5],vec2(0,0),texSize);
    fsTexCoords[6]=clamp(fsTexCoords[6],vec2(0,0),texSize);
    fsTexCoords[7]=clamp(fsTexCoords[7],vec2(0,0),texSize);
    fsTexCoords[8]=clamp(fsTexCoords[8],vec2(0,0),texSize);
    fsTexCoords[9]=clamp(fsTexCoords[9],vec2(0,0),texSize);
    fsTexCoords[10]=clamp(fsTexCoords[10],vec2(0,0),texSize);
    fsTexCoords[11]=clamp(fsTexCoords[11],vec2(0,0),texSize);
    fsTexCoords[12]=clamp(fsTexCoords[12],vec2(0,0),texSize);
    fsTexCoords[13]=clamp(fsTexCoords[13],vec2(0,0),texSize);
    fsTexCoords[14]=clamp(fsTexCoords[14],vec2(0,0),texSize);
}
