#version 330

#include "transitionHelperGL.h"
#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform sampler2DRect maskTex;

uniform float transitionProgress=1.0;
uniform float transitionAlpha=1.0;
uniform float baseAlpha=1.0;
uniform int transitionState;
in vec2 fsMaskTexture;


in vec2 fsTexture;
in vec2 fsTexture2;
in float fsMix;
out vec4 outColor;


vec4 grayscale (vec4 color)
{
    float gray=0.2126*color.r + 0.7152*color.g + 0.0722*color.b;
    return vec4(gray,gray,gray,color.a);
}

void main()
{
    vec4 texel1=getColor(inputTex,fsTexture);

#ifndef PRE_MULT
    multiplyAlpha(texel1);
#endif

    vec4 color1=mix(grayscale(texel1),texel1,smoothstep(.6,1.0,1.0-fsMix));
    if(transitionState==2)
        outColor=mix(color1,vec4(0,0,0,0),transitionProgress);
    else
        outColor=mix(vec4(0,0,0,0),color1,transitionProgress);

    float alpha = baseAlpha;

#ifdef USE_MASK
    alpha *= texture(maskTex, fsMaskTexture).a;
#endif

    multiplyOpacityPremultiplied(outColor, alpha);

#ifndef PRE_MULT
    divideAlpha(outColor);
#endif
}
