#version 330

#include "transitionHelperGL.h"
#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform sampler2DRect maskTex;

uniform float transitionProgress=1.0;
uniform float transitionProgressLinear=1.0;
uniform float transitionAlpha=1.0;
uniform int transitionState;
uniform float baseAlpha=1.0;
in vec2 fsMaskTexture;

in vec2 fsTexture;
in vec2 fsTexture2;
in vec2 fsTextureSize;
in float fsMix;
in float fsABSelect;

out vec4 outColor;

uniform float blocksize=1.;

//float rand(vec2 co)
//{
//    return fract(sin(dot(co, vec2(12.9898, 78.233))) * 43758.5453);
//}

highp float rand(vec2 co)
{
    highp float a = 12.9898;
    highp float b = 78.233;
    highp float c = 43758.5453;
    highp float dt= dot(co.xy ,vec2(a,b));
    highp float sn= mod(dt,3.14);
    return fract(sin(sn) * c);
}


void main()
{
    vec2 p=fsTexture/fsTextureSize;
    float mixVal=1.;
    //    if(transitionState==0)
    mixVal=step(rand(floor(gl_FragCoord.xy/blocksize)), fsMix);
    vec4 texColor=getColor(inputTex,fsTexture);
    vec4 texelA=mix(vec4(0,0,0,0),texColor,fsABSelect);
    vec4 texelB=mix(texColor,vec4(0,0,0,0),fsABSelect);

    outColor = mix(texelB, texelA, mixVal);
    float alpha = baseAlpha;
#ifdef USE_MASK
    alpha *= texture(maskTex, fsMaskTexture).a;
#endif
    multiplyOpacity(outColor, alpha);
}
