#version 330

uniform sampler2DRect inputTex;
uniform sampler2DRect maskTex;

layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;
layout (location=2) in vec2 vsTextureMask;

out vec2 fsTexture;
out vec2 fsMaskTexture;
out vec2 fsNormalizedUV;
out vec2 fsTextureSize;

void main()
{
    gl_Position=vec4(vsPosition.x,vsPosition.y,vsPosition.z,1.0);
    fsTexture = vsTexture;
    ivec2 texSize = textureSize(inputTex);
    fsTexture = vsTexture;
    fsTextureSize=vec2(texSize);
    fsNormalizedUV=vsTexture/fsTextureSize;
    fsMaskTexture = vsTextureMask;
}
