// Convert (and horizontal downsample) RGB to YUV2 using HD gamma corrected values (from Decklink SDK)
#version 330

uniform sampler2DRect inputTex;

const vec4 std709X = vec4(  0.183,   0.614,  0.062, 0.0  );
const vec4 std709Y = vec4( -0.101,  -0.338,  0.439, 0.0  );
const vec4 std709Z = vec4(  0.439,  -0.399, -0.040, 0.0  );

in vec2 fsTex0;

layout(location = 0) out vec4 outColor;

void main()
{
    vec4 texColor0;
    vec4 texColor1;
    vec4 yuv0;
    vec4 yuv1;
    vec2 texLoc=fsTex0;
    texLoc+=vec2(.5,.5); //we are downsampling horizontally and verticallly.  In theory we can just offset our sample point by have a pixel and have the hardware do the downsample for us

    texColor0 = texture(inputTex, texLoc);
    texLoc.x+=1.0;
    texColor1 = texture(inputTex, texLoc);


    yuv0 = vec4(dot(std709X, texColor0)+0.0625,
                dot(std709Y, texColor0)+0.5,
                dot(std709Z, texColor0)+0.5,
                1.0 );
    yuv1 = vec4(dot(std709X, texColor1)+0.0625,
                dot(std709Y, texColor1)+0.5,
                dot(std709Z, texColor1)+0.5,
                1.0 );

    outColor=vec4(yuv0.g,yuv0.b,yuv1.g,yuv1.b);
}


