// Convert (and horizontal downsample) RGB to YUV2 using HD gamma corrected values (from Decklink SDK)
#version 330

uniform sampler2DRect inputTex;

const vec4 std709X = vec4(  0.183,   0.614,  0.062, 0.0  );
const vec4 std709Y = vec4( -0.101,  -0.338,  0.439, 0.0  );
const vec4 std709Z = vec4(  0.439,  -0.399, -0.040, 0.0  );

in vec2 fsTex0;

out vec4 yuva;

void main()
{
    vec4 texColor0;
    vec4 yuv0;
    
    texColor0 = texture(inputTex, fsTex0);

    yuv0 = vec4(dot(std709X, texColor0)+0.0625,
                dot(std709Y, texColor0)+0.5,
                dot(std709Z, texColor0)+0.5,
                texColor0.a);

    yuva=vec4(yuv0.g,yuv0.r,yuv0.a,yuv0.b);
}
