#version 330


layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;
layout (location=2) in vec2 vsTextureMask;

uniform sampler2DRect maskTex;
uniform vec2 windowSize;
out vec2 fsFragScale;


uniform mat4 worldViewProj;
uniform int transitionState;
uniform float transitionProgress=1.0;
uniform sampler2DRect inputTex;

uniform int direction=0;

const vec4 deltaTransTable[9] = vec4[]  (
                                         vec4(-2.,2.,0.,.0),
                                         vec4( 0.,2.,0.,.0),
                                         vec4( 2.,2.,0.,.0),
                                         vec4(-2.,0.,0.0,.0),
                                         vec4( 0.,0.,0.0,.0),
                                         vec4( 2.,0.,0.0,.0),
                                         vec4(-2.,-2.,0.,.0),
                                         vec4( 0.,-2.,0.,.0),
                                         vec4( 2.,-2.,0.,.0)
                                         );

const vec4 transOffsetTable[9] = vec4[]  (
                                          vec4(-2.,2.,0.0,.0),
                                          vec4( 0.,2.,0.0,.0),
                                          vec4( 2.,2.,0.0,.0),
                                          vec4(-2.,0.,0.0,.0),
                                          vec4( 0.,0.,0.0,.0),
                                          vec4( 2.,0.,0.0,.0),
                                          vec4(-2.,-2.,0.,.0),
                                          vec4( 0.,-2.,0.,.0),
                                          vec4( 2.,-2.,0.,.0)
                                          );

out vec2 fsTexture;

void main()
{
    vec4 deltaTrans=deltaTransTable[direction];
    vec4 transOffsetIn=transOffsetTable[direction];
    vec4 transOffsetOut=vec4(0.,0.,0.0,.0);

    mat4 translation=mat4(
                          1.0, 0.0, 0.0, 0.00,
                          0.0, 1.0, 0.0, 0.00,
                          0.0, 0.0, 1.0, 0.00,
                          0.0, 0.0, 0.0, 1.00);


    vec4 tmpPos=vec4(vsPosition.x,vsPosition.y,vsPosition.z,1.0)*worldViewProj;
    if(transitionState==0)
    {
        transOffsetIn-=deltaTrans*transitionProgress;

        translation[0][3]+=transOffsetIn.x;
        translation[1][3]+=transOffsetIn.y;
        translation[2][3]+=transOffsetIn.z;
    }
    else if(transitionState==2)
    {
        transOffsetOut-=deltaTrans*transitionProgress;

        translation[0][3]+=transOffsetOut.x;
        translation[1][3]+=transOffsetOut.y;
        translation[2][3]+=transOffsetOut.z;
    }
    gl_Position = tmpPos*translation;

    ivec2 texSize=textureSize(inputTex);
    fsTexture = vsTexture*vec2(texSize);
    fsFragScale=vec2(textureSize(maskTex))/windowSize;
}
