#version 330


layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;
layout (location=2) in vec2 vsTextureMask;

uniform sampler2DRect maskTex;
uniform vec2 windowSize;
out vec2 fsFragScale;


uniform mat4 worldViewProj;
uniform int transitionState;
uniform float transitionProgress=1.0;
uniform sampler2DRect inputTex;

out vec2 fsTexture;
out float fsMix;

uniform int direction=0;

const vec4 deltaTransTable[9] = vec4[]  (
                                         vec4(-2.,2.,0.,.0),
                                         vec4( 0.,2.,0.,.0),
                                         vec4( 2.,2.,0.,.0),
                                         vec4(-2.,0.,0.0,.0),
                                         vec4( 0.,0.,0.0,.0),
                                         vec4( 2.,0.,0.0,.0),
                                         vec4(-2.,-2.,0.,.0),
                                         vec4( 0.,-2.,0.,.0),
                                         vec4( 2.,-2.,0.,.0)
                                         );

const vec4 transOffsetTable[9] = vec4[]  (
                                          vec4(-2.,2.,0.0,.0),
                                          vec4( 0.,2.,0.0,.0),
                                          vec4( 2.,2.,0.0,.0),
                                          vec4(-2.,0.,0.0,.0),
                                          vec4( 0.,0.,0.0,.0),
                                          vec4( 2.,0.,0.0,.0),
                                          vec4(-2.,-2.,0.,.0),
                                          vec4( 0.,-2.,0.,.0),
                                          vec4( 2.,-2.,0.,.0)
                                          );


void main()
{
    vec4 deltaTrans=deltaTransTable[direction];
    vec4 transOffset=transOffsetTable[direction];

    mat4 translation=mat4(
                          1.0, 0.0, 0.0, 0.00,
                          0.0, 1.0, 0.0, 0.00,
                          0.0, 0.0, 1.0, 0.00,
                          0.0, 0.0, 0.0, 1.00);


    vec4 tmpPos=vec4(vsPosition,1.0)*worldViewProj;
    if(transitionState==0)
    {
        transOffset-=deltaTrans*transitionProgress;

        translation[0][3]+=transOffset.x;
        translation[1][3]+=transOffset.y;
        translation[2][3]+=transOffset.z;
        fsMix=1.;
    }
    else
    {
        fsMix=(1.0-transitionProgress);
    }
    gl_Position = tmpPos*translation;

    ivec2 texSize=textureSize(inputTex);
    fsTexture = vsTexture*vec2(texSize);
    fsFragScale=vec2(textureSize(maskTex))/windowSize;
}
