#version 330

#include "transitionHelperGL.h"
#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform sampler2DRect maskTex;

uniform float transitionProgress=1.0;
uniform float transitionAlpha=1.0;
uniform int transitionState;
uniform float baseAlpha=1.0;
uniform vec2 windowSize;
uniform vec2 uvScale;
in vec2 fsFragScale;
in vec2 fsPosScale;



in vec2 fsTexture;
in float texWidth;
out vec4 outColor;

void main()
{
    outColor=vec4(0,0,0,0);
    vec2 curPos=gl_FragCoord.xy*fsPosScale;
    float alpha = baseAlpha;
    if(transitionState==0)
    {
        outColor=getColor(inputTex,fsTexture);
        alpha *= transitionProgress;
    }
    else
    {
        //expanding old texture and splitting in middle
        vec2 tadj=fsTexture;
        float open=transitionProgress*.5;
        float middle=.5;
        if(curPos.x>middle)
        {
            tadj.x=fsTexture.x-(open*texWidth*uvScale.x);
            if(tadj.x/texWidth<middle)
                discard;
        }
        else
        {
            tadj.x=fsTexture.x+(open*texWidth*uvScale.x);
            if(tadj.x/texWidth>middle)
                discard;
        }
        outColor=getColor(inputTex,tadj);
    }
#ifdef USE_MASK
    alpha *= texture(maskTex, gl_FragCoord.xy * fsFragScale).a;
#endif
    multiplyOpacity(outColor, alpha);
    if(outColor.a==0.0)
        discard;
}

