#version 330

#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform sampler2DRect maskTex;
uniform float transitionProgress=1.0;
uniform float transitionProgressLinear=1.0;
uniform float transitionAlpha=1.0;
uniform float baseAlpha=1.0;

in vec2 fsTexture;
in vec2 fsTexture2;
in vec2 fsTextureSize;
in vec2 fsTextureSize2;
in vec2 fsMaskTexture;
in vec2 fsTextureNormalized;
in vec2 fsTextureNormalized2;
in vec2 fsFragScale;

out vec4 outColor;

const vec2 center = vec2(0.5, 0.5);

highp float rand(vec2 co)
{
    highp float a = 12.9898;
    highp float b = 78.233;
    highp float c = 43758.5453;
    highp float dt= dot(co.xy ,vec2(a,b));
    highp float sn= mod(dt,3.14);
    return fract(sin(sn) * c);
}


void main()
{
    vec2 p = gl_FragCoord.xy*fsFragScale;

    float x = transitionProgressLinear*2.5;
    float dist = distance(center, p);
    float r = x - min(rand(vec2(p.y, 0.0)), rand(vec2(0.0, p.x)));
    float m = dist <= r ? 1.0 : 0.0;

    outColor=mix(texture(inputTex1,fsTexture2),texture(inputTex,fsTexture),m);

#ifdef USE_MASK
    multiplyOpacity(outColor, texture(maskTex, fsMaskTexture).a);
#endif
}
