//

// Fragment shader for tile effect
//
// Author: Jeff Brown
// updated to 330 and rvfx system by Jeff Brown
//


#version 330

#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect maskTex;
uniform float uTransitionProgress=1.0;
uniform float cells;
uniform int gridSize;
uniform float uBlendValue=1.0;

in vec2 fsTexture;
in vec2 fsMaskTexture;
in vec2 fsNormalizedUV;
in vec2 fsTextureSize;

out vec4 outColor;

void main()
{
    vec2 xy;
    vec4 texel=texture(inputTex,fsTexture);
    float rows=cells;
    float columns=cells;
    if(gridSize!=0)
    {
        xy=fsNormalizedUV*vec2(float(columns),float(rows));
        xy=fract(xy);
        vec2 pos=vec2(3.1415926535,3.1415926535)*xy;
        vec2 dim=sqrt(min(vec2(1.0),sin(pos)*vec2(22.0-float(gridSize))));
        outColor = texture(inputTex, xy * fsTextureSize);
        multiplyOpacity(outColor, dim.x * dim.y);
    }
    else
    {
        //        xy=fsNormalizedUV*vec2(float(columns),float(rows));
        xy=fsNormalizedUV*vec2(columns,rows);
        xy=fract(xy)*fsTextureSize;
        outColor = texture(inputTex,xy);
    }

    float blendValue = uBlendValue;
#ifdef USE_MASK
    blendValue *= texture(maskTex, fsMaskTexture).a;
#endif
    mixColor(outColor, texel, outColor, blendValue);
}
