// Convert (and horizontal downsample) RGB to YUV2 using HD gamma corrected values (from Decklink SDK)
#version 330

uniform sampler2DRect inputTex;

const vec4 std709X = vec4(  0.183,   0.614,  0.062, 0.0  );
const vec4 std709Y = vec4( -0.101,  -0.338,  0.439, 0.0  );
const vec4 std709Z = vec4(  0.439,  -0.399, -0.040, 0.0  );

in vec2 fsTex0;
in vec2 fsTex1;
in vec2 fsTex2;
in vec2 fsTex3;

layout(location = 0) out vec4 yValue;
layout(location = 1) out vec4 uValue;
layout(location = 2) out vec4 vValue;

void main()
{
    vec4 texColor0;
    vec4 texColor1;
    vec4 texColor2;
    vec4 texColor3;
    vec4 yuv0;
    vec4 yuv1;
    vec4 yuv2;
    vec4 yuv3;

    texColor0 = texture(inputTex, fsTex0);
    texColor1 = texture(inputTex, fsTex1);
    texColor2 = texture(inputTex, fsTex2);
    texColor3 = texture(inputTex, fsTex3);
    
    yuv0 = vec4(dot(std709X, texColor0)+0.0625,
                dot(std709Y, texColor0)+0.5,
                dot(std709Z, texColor0)+0.5,
                1.0 );

    yuv1 = vec4(dot(std709X, texColor1)+0.0625,
                dot(std709Y, texColor1)+0.5,
                dot(std709Z, texColor1)+0.5,
                1.0 );

    yuv2 = vec4(dot(std709X, texColor2)+0.0625,
                dot(std709Y, texColor2)+0.5,
                dot(std709Z, texColor2)+0.5,
                1.0 );

    yuv3 = vec4(dot(std709X, texColor3)+0.0625,
                dot(std709Y, texColor3)+0.5,
                dot(std709Z, texColor3)+0.5,
                1.0 );


    float u=(yuv0.b+yuv1.b+yuv2.b+yuv3.b)*.25;
    float v=(yuv0.g+yuv1.g+yuv2.g+yuv3.g)*.25;
    float y=yuv0.r;
    // y=1.0;
    // u=1.0;
    // v=1.0;
    yValue=vec4(y,y,y,y);
    uValue=vec4(u,u,u,u);
    vValue=vec4(v,v,v,v);
}


