#version 330

uniform sampler2DRect inputTex;
uniform sampler2DRect maskTex;

layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;

uniform float uPass=0.0;
uniform float downsampleStep=1.f;
uniform float textureScale;

out vec2 fsTexCoords[4];
out vec2 fsTexture;
out vec2 fsMaskTexture;

void main()
{
    gl_Position=vec4(vsPosition.x,vsPosition.y,vsPosition.z,1.0);

    ivec2 iTexSize=textureSize(inputTex);
    vec2 texSize=vec2(iTexSize);
    fsMaskTexture=vsTexture/texSize;

    iTexSize=textureSize(maskTex);
    fsMaskTexture*=vec2(iTexSize);

    vec2 pixelOffset=vec2(1.0,1.0);
    fsTexture=vsTexture*texSize;

    fsTexCoords[0]=fsTexture+pixelOffset*vec2(0.,0.)*downsampleStep;
    fsTexCoords[1]=fsTexture+pixelOffset*vec2(0.,1.)*downsampleStep;
    fsTexCoords[2]=fsTexture+pixelOffset*vec2(1.,1.)*downsampleStep;
    fsTexCoords[3]=fsTexture+pixelOffset*vec2(0.,1.)*downsampleStep;
}
