function BindClick(element, callback) {
  element.click(function() {
    callback(this);

    return false;
  });
};

function Enable(element) {
  element.removeClass('disabled');
};

function Disable(element) {
  element.addClass('disabled');
};

function GetID(element) {
  return element.prop('id');
}

function SetID(element, value) {
  element.prop('id', value);
}

function Post(url, data, expectResponse = true) {
  let jsondata = JSON.stringify(data);

  return $.ajax({
    type: 'POST',
    url: url,
    data: jsondata,
    contentType: 'application/json',
    dataType: expectResponse ? 'json' : undefined });
};

function Get(url, data) {
  let jsondata = JSON.stringify(data);

  return $.ajax({
    type: 'GET',
    url: url,
    data: jsondata,
    contentType: 'application/json',
    dataType: 'json' });
};
