//

// Fragment shader for blend generated plasma with image
//
// Author: Blah, i can neither confirm nor deny i wrote this
//
//

#version 330

#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect maskTex;
uniform float blendValue;
uniform float uBlendValue=1.0;

in vec2 fsTexture;
in vec2 fsMaskTexture;
in vec2 fsNormalizedUV;
in vec2 fsTextureSize;
in float fsTime;
out vec4 outColor;

const float PI = 3.14159265;


void main()
{

    float color1, color2, color;

    color1 = (sin(dot(fsTexture.xy,vec2(sin(fsTime*3.0),cos(fsTime*3.0)))*0.02+fsTime*3.0)+1.0)/2.0;

    float centerX=fsTextureSize.x/2.0;
    float centerY=fsTextureSize.y/2.0;
    vec2 center = vec2(centerX, centerY) + vec2(centerX*sin(-fsTime*3.0),centerY*cos(-fsTime*3.0));

    color2 = (cos(length(fsTexture.xy - center)*0.03)+1.0)/2.0;

    color = (color1+ color2)/2.0;

    float red = (cos(PI*color/0.5+fsTime*3.0)+1.0)/2.0;
    float green = (sin(PI*color/0.5+fsTime*3.0)+1.0)/2.0;
    float blue = (sin(+fsTime*3.0)+1.0)/2.0;

    vec4 plasma = vec4(red, green, blue, 1.0);
    outColor=texture(inputTex,fsTexture);
#ifdef PRE_MULT
    divideAlpha(outColor);
#endif
    float blendValue2=uBlendValue*blendValue;
#ifdef USE_MASK
    blendValue2*=texture(maskTex,fsMaskTexture).a;
#endif
    outColor.rgb=mix(outColor.rgb,plasma.rgb,blendValue2);
#ifdef PRE_MULT
    multiplyAlpha(outColor);
#endif
}
