#version 330

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;


layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;
layout (location=2) in vec2 vsTextureMask;
layout (location=3) in vec2 vsTexture2;

uniform sampler2DRect maskTex;
out vec2 fsMaskTexture;
out vec2 fsMaskTextureSize;

uniform mat4 worldViewProj;
uniform int transitionState;
uniform int direction=0;

out vec2 fsTexture;
out vec2 fsTexture2;
out vec2 fsTextureNormalized;
out float fsMix;
out vec2 fsNormPos;

void main()
{
    gl_Position=vec4(vsPosition.x,vsPosition.y,vsPosition.z,1.0)*worldViewProj;

    ivec2 texSize=textureSize(inputTex);
    fsTextureNormalized=vsTexture;
    fsTexture=vsTexture*vec2(texSize);

    texSize=textureSize(inputTex1);
    fsTexture2=vec2(texSize)*vsTexture2;

    fsMaskTextureSize = vec2(textureSize(maskTex));
    fsMaskTexture = vsTextureMask * fsMaskTextureSize;

    fsMix = transitionState == 0 ? 1.0 : 0.0;
    fsNormPos = vsPosition.xy * 0.5 + vec2(0.5, 0.5);
}

