
#include "metalShaderTypes.h"
#include "alpha.h"

typedef struct
{
    int direction;
} fxVars;

vertex vertexOut vertexFunc(uint vertexID [[ vertex_id ]],const device txShaderVers* in[[ buffer(0) ]],constant txShaderUniforms& uniforms[[ buffer(3) ]],constant fxVars& vars[[ buffer(2)]])
{
    vertexOut out;

    out.position=in[vertexID].pos*uniforms.worldViewProj;

    out.tex1=in[vertexID].tex1;
    out.tex2=in[vertexID].tex2;
    out.texMask=in[vertexID].texMask;
    out.normPos=in[vertexID].pos.xy*vec2(.5,.5f)+vec2(.5,.5);
    return out;
}

vec2 offset(float scale,float progress, float x, float theta)
{
    float shifty = 0.023*scale*cos(10.0*(progress+x));
    return vec2(0, shifty);
}

fragment float4 fragmentFunc(vertexOut input [[stage_in]]
                             ,texture2d<half> inputTex0 [[ texture(0) ]]
                             ,texture2d<half> inputTex1 [[ texture(1) ]]
                             ,texture2d<half> inputTexMask [[ texture(2) ]]
                             ,constant txShaderUniforms& u[[ buffer(2) ]]
                             ,constant subFXVars& subVars[[buffer(3)]]
                             ,constant fxVars& vars[[ buffer(1)]])
{
    float fsMix=u.transitionProgress;
    float fsProgress;
    if(u.transitionProgress<.5)
    {
        fsProgress=u.transitionProgressLinear/.5;
    }
    else
    {
        fsProgress=1.-(u.transitionProgressLinear-.5)/.5;
    }

    vec2 p1 = input.tex1;
    vec4 texColor;
    if(u.transitionState==2)
        texColor=getColor(inputTex0,(p1+offset(fsProgress,fsMix,p1.x,3.145)));
    else
        texColor=getColor(inputTex0,(p1+offset(fsProgress,fsMix,p1.x,0.0)));

    vec4 colorA=mix(vec4(0,0,0,0),texColor,u.mix);
    vec4 colorB=mix(texColor,vec4(0,0,0,0),u.mix);

    float4 outColor;
    mixColor(outColor, colorB, colorA, u.transitionProgressLinear);

    float alpha = u.baseAlpha;
#ifdef USE_MASK
    alpha *= float(inputTexMask.sample(linearSampler, input.texMask).a);
#endif
    multiplyOpacity(outColor, alpha);

    return outColor;
}
