#version 330

#include "transitionHelperGL.h"
#include "alpha.h"
#include "fadeHelper.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect maskTex;
uniform float transitionProgress = 1.0;
uniform float baseAlpha = 1.0;
uniform vec4 burnColor;

in vec2 fsTexture;
in vec2 fsMaskTexture;
in float fsMix;

out vec4 outColor;

void main()
{
    vec4 texColor = getColor(inputTex, fsTexture);
    vec4 burnColor = burnColor;
#ifndef PRE_MULT
    multiplyAlpha(texColor);
#endif
    multiplyAlpha(burnColor); // burnColor always comes in straight alpha
    colorBurn(outColor, texColor, burnColor, transitionProgress, fsMix);
    float alpha = baseAlpha;
#ifdef USE_MASK
    alpha *= texture(maskTex, fsMaskTexture).a;
#endif
    outColor *= alpha;
#ifndef PRE_MULT
    divideAlpha(outColor);
#endif
}
