#version 330

#include "alpha.h"

uniform sampler2DRect inputTex0;
uniform sampler2DRect inputTex1;
uniform sampler2DRect inputTexMask;
uniform vec4 endColor;
uniform float endOpacity;



const vec4 std709R = vec4( 1.793,1.164383, 0.000000,0.0  );
const vec4 std709G = vec4(-0.534,1.164383,-0.213,0.0  );
const vec4 std709B = vec4( 0.000000,1.164383, 2.115,0.0  );
const vec4 stdbias = vec4(-0.5  , -0.0535,  -0.5   ,0.0  );

//const vec4 std709R = vec4( 1.5701,1., 0.000000,0.0  );
//const vec4 std709G = vec4(-0.4664,1.,-0.1870,0.0  );
//const vec4 std709B = vec4( 0.000000,1., 1.8556,0.0  );
//const vec4 stdbias = vec4(-0.5  ,-0.0535,  -0.5   ,0.0  );

in vec2 fsTexY;
in vec2 fsTexUV;
in vec2 fsTextureMask;
out vec4 outColor;

void main()
{
    vec4 yuvIn;
    vec4 yuvOut;
    yuvIn.a=0.0;
    yuvIn.g = texture(inputTex0, fsTexY).r;
    yuvIn.br = texture(inputTex1, fsTexUV).rg;

    yuvIn+=stdbias;


    outColor=vec4(dot(std709R, yuvIn),
                  dot(std709G, yuvIn),
                  dot(std709B, yuvIn),
                  1.0);

#ifdef USE_MASK
    multiplyOpacity(outColor, texture(inputTexMask, fsTextureMask).a);
#endif

#ifdef USE_END_COLOR
    mixColor(outColor, endColor, outColor, endOpacity);
#endif

}
