#include "metalShaderTypes.h"
#include "alpha.h"
#include "commonMLDX.h"
#include "outputColorHelper.h"


typedef struct
{
    float4 position [[position]];
    float2 texCoord;
    float2 texCoordMask;
    float alpha;
} fsPixCopy;


constexpr sampler nearestSampler(
    mip_filter::nearest,
    mag_filter::nearest,
    min_filter::nearest,
    address::clamp_to_border,
    border_color::transparent_black);

vertex fsPixCopy vertexFunc(uint vertexID [[ vertex_id ]],const device pixCopyVertexFormat* in[[ buffer(0) ]])
{
    fsPixCopy out;

    out.position = in[vertexID].pos;

    out.texCoord = in[vertexID].tc;

    return out;
}

fragment float4 fragmentFunc(fsPixCopy input [[stage_in]], texture2d<half> baseMap [[ texture(0) ]],texture2d<half> maskMap [[ texture(1) ]])
{

    float4 baseColor = float4(baseMap.sample (linearSampler, input.texCoord.xy));
    return toOutput(baseColor);
}
