#version 330

#include "alpha.h"

uniform sampler2DRect inputTex;
uniform float transitionProgress=1.0;
uniform float transitionAlpha=1.0;
uniform float baseAlpha=1.0;
uniform float fadeLeft=1.0;
uniform float fadeRight=1.0;
uniform float fadeTop=1.0;
uniform float fadeBottom=1.0;
uniform sampler2DRect maskTex;
in vec2 fsMaskTexture;

in vec2 fsTexture;
in vec2 fsVertex;
out vec4 outColor;

void main()
{
    outColor = texture(inputTex, fsTexture);
    vec2 t=(fsVertex+vec2(1.0,1.0))*.5;
    float blend = smoothstep(0.0, fadeLeft, t.x) * (1 - smoothstep(fadeRight, 1.0, t.x)) * smoothstep(0.0, fadeTop, t.y) * (1 - smoothstep(fadeBottom, 1.0, t.y));
#ifdef USE_MASK
    blend *= texture(maskTex, fsMaskTexture).a;
#endif
    multiplyOpacity(outColor, blend);
}
