#version 330

#include "transitionHelperGL.h"
#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform sampler2DRect maskTex;

uniform float transitionProgress=1.0;
uniform float transitionAlpha=1.0;
uniform float baseAlpha=1.0;


in vec2 fsTexture1;
in vec2 fsTexture2;
in vec2 fsMaskTexture;
in vec2 fsTexture2Normalized;

out vec4 outColor;

layout( std140 ) uniform vars
{
    float shadowEnable;
    float pad[3];
};

void main()
{
    vec4 blur=texture(inputTex,fsTexture1);
    vec4 org=texture(inputTex1,fsTexture2);

    float shadowWidth = 0.05;
    float edgeDistX = abs(fsTexture2Normalized.x - clamp(fsTexture2Normalized.x, 0.0, 1.0));
    float edgeDistY = abs(fsTexture2Normalized.y - clamp(fsTexture2Normalized.y, 0.0, 1.0));
    float edgeDist = max(edgeDistX, edgeDistY);

    float shadowStrength = smoothstep(0.0, shadowWidth, edgeDist);

    float minShadowStrength = 0.55; // we don't want it completely dark on edges, so limit to 55%
    float maxShadowStrength = 0.85; // we want to darken the entire blurred area a bit as well

    float remappedShadowStrength = minShadowStrength + (maxShadowStrength - minShadowStrength) * shadowStrength;

    vec3 shadowBlur=blur.rgb*remappedShadowStrength;

    blur.rgb=mix(blur.rgb,shadowBlur.rgb,shadowEnable);

    blendColorSrcOverDst(outColor, org, blur);

#ifdef USE_MASK
    multiplyOpacity(outColor, texture(maskTex, fsMaskTexture).a);
#endif
}
