typedef struct
{
    float notUsed;
} subFXVars;


float4 backgroundEffect(texture2d<half> objectTexture,
                        float2 objectTextureCoordinates,
                        texture2d<half> blurredBackgroundTexture,
                        texture2d<half> backgroundTexture,
                        float2 screenPosition,
                        constant txShaderUniforms& u,
                        constant subFXVars& vars)
{
    float4 objectColor=float4(objectTexture.sample(linearSampler,objectTextureCoordinates));
    
    float4 backgroundColor=float4(backgroundTexture.sample(linearSampler,screenPosition*u.uvScale+u.uvOffset));
    float4 invertedBackgroundColor=float4(1.0);
    invertedBackgroundColor.rgb-=backgroundColor.rgb;

    float4 outColor=mix(invertedBackgroundColor,backgroundColor,1.0-objectColor.a);

    outColor*=objectColor.a;

    return outColor;
}
