#version 330

uniform sampler2DRect inputTex;
uniform sampler2DRect maskTex;

layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;

out vec2 fsTexture;
out vec2 fsMaskTexture;

void main()
{
    gl_Position=vec4(vsPosition.x,vsPosition.y,vsPosition.z,1.0);
    fsTexture = vsTexture;

    ivec2 texSize=textureSize(inputTex);
    fsMaskTexture=vsTexture/vec2(texSize);

    texSize=textureSize(maskTex);
    fsMaskTexture*=vec2(texSize);
}
