#version 330

#include "transitionHelperGL.h"
#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform sampler2DRect maskTex;

uniform float transitionProgress=1.0;
uniform float transitionProgressLinear=1.0;
uniform float transitionAlpha=1.0;
uniform float baseAlpha=1.0;
uniform int transitionState;
uniform vec4 burnColor;

in vec2 fsTexture;
in vec2 fsTexture2;
in vec2 fsTextureSize;
in vec2 fsTextureSize2;
in vec2 fsMaskTexture;
in vec2 fsTextureNormalized;
in vec2 fsTextureNormalized2;
in float fsTheta;
in float fsProgress;
in float fsMix;

out vec4 outColor;

vec2 offset(float scale,float progress, float x, float theta)
{
    float phase = progress*progress + progress + theta;
    float shifty = 0.023*scale*cos(10.0*(progress+x));
    return vec2(0, shifty);
}

void main()
{
    vec2 p1 = fsTextureNormalized;
    vec2 p2 = fsTextureNormalized2;

    vec4 colorA=getColor(inputTex,(p1+offset(fsProgress,fsMix,p1.x,0.0))*fsTextureSize);

    float prog = transitionState == 0 ? transitionProgressLinear : 1.0 - transitionProgressLinear;
    mixColor(outColor, vec4(0,0,0,0), colorA, prog);

    float alpha = baseAlpha;
#ifdef USE_MASK
    alpha *= texture(maskTex, fsMaskTexture).a;
#endif
    multiplyOpacity(outColor, alpha);
}
