#include "metalShaderTypes.h"
#include "alpha.h"

typedef struct
{
    int direction;
} fxVars;

vertex vertexOut vertexFunc(uint vertexID [[ vertex_id ]],const device txShaderVers* in[[ buffer(0) ]],constant txShaderUniforms& uniforms[[ buffer(3) ]],constant fxVars& vars[[ buffer(2)]])
{
    vertexOut out;

    out.position=in[vertexID].pos*uniforms.worldViewProj;

    out.tex1=in[vertexID].tex1;
    out.tex2=in[vertexID].tex2;
    out.texMask=in[vertexID].texMask;
    out.normPos=in[vertexID].pos.xy*vec2(.5,.5f)+vec2(.5,.5);
    return out;
}

fragment float4 fragmentFunc(vertexOut input [[stage_in]]
                             ,texture2d<half> inputTex0 [[ texture(0) ]]
                             ,texture2d<half> inputTex1 [[ texture(1) ]]
                             ,texture2d<half> inputTexMask [[ texture(2) ]]
                             ,constant txShaderUniforms& u[[ buffer(2) ]]
                             ,constant subFXVars& subVars[[buffer(3)]]
                             ,constant fxVars& vars[[ buffer(1)]])
{
    float x1 = u.transitionProgressLinear;
    vec2 p1 = input.tex1;

    x1=smoothstep(.20,.80,(x1*2.0+p1.x-1.0));

    vec2 tc1=(p1-.5)*(1.-x1)+.5;

    tc1=(p1-.5)*x1+.5;

    vec2 texA=mix(tc1,p1,u.transitionProgressLinear);
    vec2 texB=mix(p1,tc1,u.transitionProgressLinear);
    vec2 useTex=mix(texB,texA,u.mix);

    vec4 outColor = getColor(inputTex0, useTex);

    float fsMix = u.transitionState == 2 ? 1.0 - u.transitionProgress : u.transitionProgress;
    float alpha = fsMix * u.baseAlpha;
#ifdef USE_MASK
    alpha *= float(inputTexMask.sample(linearSampler, input.texMask).a);
#endif
    multiplyOpacity(outColor, alpha);

    return outColor;
}
