#version 330

#include "transitionHelperGL.h"
#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform sampler2DRect maskTex;

uniform float transitionProgress=1.0;
uniform float transitionProgressLinear=1.0;
uniform float transitionAlpha=1.0;
uniform float baseAlpha=1.0;
uniform vec4 burnColor;

in vec2 fsTexture;
in vec2 fsTexture2;
in vec2 fsTextureSize;
in vec2 fsTextureSize2;
in vec2 fsMaskTexture;
in vec2 fsTextureNormalized;
in vec2 fsTextureNormalized2;
in float fsABSelect;

out vec4 outColor;

uniform ivec2 size=ivec2(10,10);
uniform float smoothness=1.0;

float rand(vec2 co)
{
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

void main()
{
    float progress=transitionProgressLinear;
    float revProgress = (1.0 - progress);
    float distFromEdges = min(progress, revProgress);

    vec2 p = fsTextureNormalized;

    vec4 texColor=texture(inputTex,fsTexture);
    vec4 texelA=mix(vec4(0,0,0,0),texColor,fsABSelect);
    vec4 texelB=mix(texColor,vec4(0,0,0,0),fsABSelect);

    float squareSize = fsTextureSize.x*.05;
    float flickerSpeed = 60.0;

    vec2 seed = floor(fsTexture / squareSize) * floor(distFromEdges * flickerSpeed);

    mixColor(outColor, texelB, texelA, transitionProgress);

#ifdef PRE_MULT
    divideAlpha(outColor);
#endif

    outColor.rgba += rand(seed) * distFromEdges * 0.5;

#ifdef OPACITY_MASK
    outColor.a = min(texColor.a, outColor.a);
#endif

#ifdef PRE_MULT
    multiplyAlpha(outColor);
#endif

    float alpha = baseAlpha;
#ifdef USE_MASK
    alpha *= texture(maskTex, fsMaskTexture).a;
#endif
    multiplyOpacity(outColor, alpha);
}
