#version 330


layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;
layout (location=2) in vec2 vsTextureMask;
layout (location=3) in vec2 vsTexture2;

uniform int transitionState;
uniform float transitionProgress=1.0;
uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform sampler2DRect maskTex;
uniform mat4 worldViewProj;


out vec2 fsTexture;
out vec2 fsTexture2;
out vec2 fsMaskTexture;
out float fsMix;

void main()
{
    gl_Position=vec4(vsPosition,1.0)*worldViewProj;
    
    fsTexture = vsTexture*vec2(textureSize(inputTex));
    fsTexture2 = vsTexture2*vec2(textureSize(inputTex1));
    if(transitionProgress<=.5)
        fsMix=transitionProgress*2.;
    else
        fsMix=(1.-transitionProgress)*2.;

    fsMaskTexture=vsTextureMask*vec2(textureSize(maskTex));
}
