#version 330

#include "transitionHelperGL.h"
#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform sampler2DRect maskTex;
uniform float transitionProgressLinear=1.0;
uniform float transitionAlpha=1.0;
uniform float baseAlpha=1.0;
uniform vec4 burnColor=vec4(0,0,0,0);

in vec2 fsTexture;
in vec2 fsTexture2;
in vec2 fsMaskTexture;
in float fsMix;

out vec4 outColor;

void main()
{
    outColor = transitionProgressLinear < 0.5
        ? getColor(inputTex1, fsTexture2)
        : getColor(inputTex, fsTexture);

#ifndef PRE_MULT
    multiplyAlpha(outColor);
#endif

    outColor = transitionProgressLinear < 0.5
        ? mix(outColor, burnColor, transitionProgressLinear * 2.0)
        : mix(burnColor, outColor, (transitionProgressLinear - 0.5) * 2.0);

#ifdef USE_MASK
    multiplyOpacityPremultiplied(outColor, texture(maskTex, fsMaskTexture).a);
#endif

#ifndef PRE_MULT
    divideAlpha(outColor);
#endif
}
