#version 330

#include "transitionHelperGL.h"
#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform sampler2DRect maskTex;

uniform float transitionProgressLinear=1.0;
uniform float transitionAlpha=1.0;
uniform float baseAlpha=1.0;
uniform int transitionState;
uniform vec4 burnColor=vec4(0,0,0,0);

in vec2 fsTexture;
in vec2 fsTexture2;
in vec2 fsMaskTexture;
in float fsMix;

out vec4 outColor;

void main()
{
    outColor = getColor(inputTex, fsTexture);
    float alpha = fsMix * baseAlpha;

#ifdef USE_MASK
    alpha *= texture(maskTex, fsMaskTexture).a;
#endif

    multiplyOpacity(outColor, alpha);
}
