#version 330


layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;
layout (location=2) in vec2 vsTextureMask;
layout (location=3) in vec2 vsTexture2;

uniform sampler2DRect maskTex;
uniform vec2 windowSize=vec2(1920.0,1080.0);
out vec2 fsFragScale;
out vec2 fsPosScale;


uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform mat4 worldViewProj;
uniform int transitionState;
uniform float transitionProgress=1.0;

out vec2 fsTexture;
out vec2 fsTexture2;
out float texWidth;


void main()
{
    gl_Position=vec4(vsPosition.x,vsPosition.y,vsPosition.z,1.0)*worldViewProj;

    ivec2 texSize=textureSize(inputTex);
    fsTexture = vsTexture*vec2(texSize);
    texWidth=float(texSize.x);
    fsTexture2=vsTexture2*vec2(textureSize(inputTex1));

    fsFragScale=vec2(textureSize(maskTex))/windowSize;
    fsPosScale=vec2(1.0,1.0)/windowSize;
}
