#version 330

#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform float transitionProgressLinear=1.0;
uniform float transitionAlpha=1.0;
uniform float baseAlpha=1.0;
uniform sampler2DRect maskTex;
in vec2 fsMaskTexture;


in vec2 fsTexture;
in vec2 fsTexture2;

out vec4 outColor;

void main()
{
    vec4 colorA = texture(inputTex, fsTexture);
    vec4 colorB = texture(inputTex1, fsTexture2);
    mixColor(outColor, colorB, colorA, transitionProgressLinear);

#ifdef USE_MASK
    multiplyOpacity(outColor, texture(maskTex, fsMaskTexture).a);
#endif
}
