#version 330

#include "transitionHelperGL.h"
#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform sampler2DRect maskTex;

uniform float transitionProgress=1.0;
uniform float transitionProgressLinear=1.0;
uniform float transitionAlpha=1.0;
uniform float baseAlpha=1.0;

in vec2 fsTexture;
in vec2 fsTexture2;
in vec2 fsTextureSize;
in vec2 fsTextureSize2;
in vec2 fsMaskTexture;
in vec2 fsTextureNormalized;
in vec2 fsTextureNormalized2;
in vec2 fsFragScale;
in float fsMix;

out vec4 outColor;

const vec2 center = vec2(0.5, 0.5);

highp float rand(vec2 co)
{
    highp float a = 12.9898;
    highp float b = 78.233;
    highp float c = 43758.5453;
    highp float dt= dot(co.xy ,vec2(a,b));
    highp float sn= mod(dt,3.14);
    return fract(sin(sn) * c);
}


void main()
{
    vec2 p = gl_FragCoord.xy*fsFragScale;

    float x = transitionProgressLinear*2.5;
    float dist = distance(center, p);
    float r = x - min(rand(vec2(p.y, 0.0)), rand(vec2(0.0, p.x)));
    float m = dist <= r ? 1.0 : 0.0;


    vec4 texColor = getColor(inputTex, fsTexture);
    vec4 colorA=mix(vec4(0,0,0,0),texColor,fsMix);
    vec4 colorB=mix(texColor,vec4(0,0,0,0),fsMix);

    outColor=mix(colorB,colorA,m);

    float alpha = baseAlpha;
#ifdef USE_MASK
    alpha *= texture(maskTex, fsMaskTexture).a;
#endif
    multiplyOpacity(outColor, alpha);
}
