//
// adjust alpha
//

#version 330

uniform sampler2DRect inputTex;
uniform sampler2DRect maskTex;

uniform float amount;
uniform float uBlendValue=1.0;

in vec2 fsTexture;
in vec2 fsMaskTexture;

out vec4 outColor;

void main(void)
{
    vec4 texColor = texture(inputTex, fsTexture);
    outColor = texColor * vec4(1.0, 1.0, 1.0, amount);

    float blendValue = uBlendValue;
#ifdef USE_MASK
    blendValue *= texture(maskTex, fsMaskTexture).a;
#endif
    outColor.rgb = mix(texColor.rgb, outColor.rgb, blendValue);
}
